/*
 * WEKA Pore Processor
 * Macro template to process multiple images in a folder
 */

#@ File (label = "Input directory", style = "directory") input
//#@ File (label = "Output directory", style = "directory") output
#@ File (label = "Classifier Model Folder", style = "directory") wekaModelDirectory
#@ String (label = "File suffix", value = ".tif") suffix
#@ String (label = "Pore Circularity Level", value = "0.6-1.0") stringCircularity
#@ String (label = "Pore Size Level [pixels^2]", value = "25-Infinity") stringSize



//starting time
startTime = getTime();

//get input foldername
inputFolderName = substring(input,lastIndexOf(input, "/")+1, lengthOf(input));
print(inputFolderName);

//make Output Directory
folderName = "/Output V8 Circularity = " + stringCircularity + " Size = " + stringSize;
output = input + folderName;
outputSummaries = output + "/Summaries";
outputRaw = output;
File.makeDirectory(output);
File.makeDirectory(outputSummaries);
print(output);

processFolder(input);



// function to scan folders/files to find files with correct suffix
//uncomment lines 41,42,45 to also scan subfolders
function processFolder(input) {
	list = getFileList(input);
	list = Array.sort(list);
	for (i = 0; i < list.length; i++) {
		//if(File.isDirectory(input + File.separator + list[i]))
		//	processFolder(input + File.separator + list[i]);
		if(endsWith(list[i], suffix))
			processFile(input, output, list[i]);
	    // }
}

function processFile(input, output, file) {
	// Do the processing here by adding your own code.
	print("Processing: " + input + File.separator + file);
	fileTimeStart = getTime(); //for calculating processing time
	filename = input + File.separator + file;
	open(filename);
	run("Grays");
	
	

	//establish magnification, classifier model
	//organize Output Directory
	//defaults
	wekaModel = wekaModelDirectory + "/PoreClassifierV6-17500x.model"; //default model
	floatppm = 1; //default pixel/nm
	
	if(matches(list[i],".*6300.*")){
		folderName = output + "/6300x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-8900x.model";
		floatppm = 0.583;
		};
	
	if(matches(list[i],".*8900.*")){
		folderName = output + "/8900x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-8900x.model";
		floatppm = 0.82;
		};

	if(matches(list[i],".*13500.*")){
		folderName = output + "/13500x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-13500x.model";
		floatppm = 1.2367;
		};	

	if(matches(list[i],".*17500.*")){
		folderName = output + "/17500x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-17500x.model";
		floatppm = 1.6633;
		};

	if(matches(list[i],".*26500.*")){
		folderName = output + "/26500x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-26500x.model";
		floatppm = 2.52;
		};

	if(matches(list[i],".*35k.*")){ //35kx image
		folderName = output + "/35000x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-35kx.model";
		floatppm = 3.24;
		};

	if(matches(list[i],".*35000x.*")){ //35kx image
		folderName = output + "/35000x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-35kx.model";
		floatppm = 3.24;
		};

	if(matches(list[i],".*64k.*")){ //64kx image
		folderName = output + "/64000x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-64kx.model";
		floatppm = 5.92;
		};

	if(matches(list[i],".*64000x*")){ //64kx image
		folderName = output + "/64000x Images";
		File.makeDirectory(folderName);
		output = folderName;
		wekaModel = wekaModelDirectory + "/PoreClassifierV6-64kx.model";
		floatppm = 5.92;
		};

			


	//convert scale input to actual value
 	//floatppm = parseFloat(stringppm);
 	print(floatppm);

	//establish scale and size for images
	run("Set Scale...", "distance="+floatppm+" known=1 pixel=1 unit=nm");
	print("Scaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	//save Scaled images
		print("Processing: " + input + File.separator + file);
		savename = output + File.separator + "Scaled_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

//run Weka Segmentation
	print("Segmenting " + list[i]);
	run("Trainable Weka Segmentation");
	wait(3000); //make sure things don't error out

	//load classifier and process image
	
	call("trainableSegmentation.Weka_Segmentation.loadClassifier", wekaModel);
	wait(1000);
	call("trainableSegmentation.Weka_Segmentation.getResult");
	wait(1000);
	
	//save Classified Image as Segmentation
		selectWindow("Classified image");
		savename = output + File.separator + "Segmented_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
		close();
	
	//generate probability maps
	call("trainableSegmentation.Weka_Segmentation.getProbability");
	wait(1000);
	selectWindow("Probability maps");
	run("8-bit"); //convert probability maps to save space
	//save probability Maps
		savename = output + File.separator + "Probability_Maps_" + list[i];
		print("Saving to: " + savename);
		saveAs("tif",savename);
	wait(1000); //all images need to be present to run script
	
	
	//create individualized images
	run("Stack to Images");
	wait(1000); //all images need to be present to run script
	selectWindow("Wall");
	rename("Wall.png");
	selectWindow("Defocus");
	rename("Defocus.png");
	selectWindow("Membrane");
	rename("Membrane.png");
	selectWindow("Pore");//this tracks the debris profile, split into fibers and particles later
	rename("Pore.png");

	//Autothreshold and Clean Wall and Pore and Defocus and Membrane images
	selectWindow("Wall.png");
	print("Thresholding " + list[i]);
	run("Auto Threshold", "method=Minimum white");
		//cleanimage
			//Cleans up noise in image by filling in dark regions, despeckling in a loop until no noise (5px or less) groups remain, removes outliers and diates/erodes surfaces to remove surface morphological features.
				getHistogram(values, counts, 256);
					Black_Pixels = counts[255];
					e= Black_Pixels; 
					do {
						f=e;
						run("Despeckle");
						getHistogram(values, counts, 256);
						white_area1= counts[255];
						e = white_area1;
						} while(e != f);
		//save Images
		savename = output + File.separator + "Wall_Thresholded_" + list[i];
		print("Saving to: " + "Wall_Thresholded_" + list[i]);
		saveAs("png",savename);
		rename("Wall_Thresholded.png");

	selectWindow("Pore.png");
	print("Thresholding " + list[i]);
	run("Auto Threshold", "method=Yen white");
		//cleanimage and and fill pore space.
			run("Invert");
			run("Fill Holes");
			setOption("BlackBackground", false);
			run("Dilate");
			run("Fill Holes");
			run("Erode");
			run("Erode");
			run("Invert");
			//Cleans up noise in image by filling in dark regions, despeckling in a loop until no noise (5px or less) groups remain, removes outliers and diates/erodes surfaces to remove surface morphological features.
				getHistogram(values, counts, 256);
					Black_Pixels = counts[255];
					e= Black_Pixels; 
					do {
						f=e;
						run("Despeckle");
						getHistogram(values, counts, 256);
						white_area1= counts[255];
						e = white_area1;
						} while(e != f);
			run("Erode"); //erode 5x to overlap with defocus ring 
			run("Erode");
			run("Erode");
			run("Erode");
			run("Erode");
		//save Images
		savename = output + File.separator + "Pore_Thresholded_" + list[i];
		print("Saving to: " + "Pore_Thresholded_" + list[i]);
		saveAs("png",savename);
		rename("Pore_Thresholded.png");

    selectWindow("Defocus.png");
	print("Thresholding " + list[i]);
	run("Auto Threshold", "method=Otsu white");
		//cleanimage and fill defocus rings to create alternative pore counting segment
			run("Invert");
			run("Fill Holes");
			setOption("BlackBackground", false);
			run("Dilate");
			run("Fill Holes");
			run("Erode");
			run("Invert");
			//Cleans up noise in image by filling in dark regions, despeckling in a loop until no noise (5px or less) groups remain, removes outliers and diates/erodes surfaces to remove surface morphological features.
				getHistogram(values, counts, 256);
					Black_Pixels = counts[255];
					e= Black_Pixels; 
					do {
						f=e;
						run("Despeckle");
						getHistogram(values, counts, 256);
						white_area1= counts[255];
						e = white_area1;
						} while(e != f);
		
		//save Images
		savename = output + File.separator + "Defocus_Thresholded_" + list[i];
		print("Saving to: " + "Pore_Thresholded_" + list[i]);
		saveAs("png",savename);
		rename("Defocus_Thresholded.png");

	selectWindow("Membrane.png");
	print("Thresholding " + list[i]);
	run("Auto Threshold", "method=Minimum white");
		//cleanimage
		setOption("BlackBackground", false);
		run("Dilate");
		run("Fill Holes");
		run("Erode");
			//Cleans up noise in image by filling in dark regions, despeckling in a loop until no noise (5px or less) groups remain, removes outliers and diates/erodes surfaces to remove surface morphological features.
				getHistogram(values, counts, 256);
					Black_Pixels = counts[255];
					e= Black_Pixels; 
					do {
						f=e;
						run("Despeckle");
						getHistogram(values, counts, 256);
						white_area1= counts[255];
						e = white_area1;
						} while(e != f);
		//save Images
		savename = output + File.separator + "Membrane_Thresholded_" + list[i];
		print("Saving to: " + "Membrane_Thresholded_" + list[i]);
		saveAs("png",savename);
		rename("Membrane_Thresholded.png");
	
		
		
	

	//Create Defocus + Wall Composite Image
	print("Opening grayscale scaled image");
	filename = input + File.separator + file;
	open(filename);
	print("GrayScaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	rename("Grayscale.png");
	run("8-bit");
	print("Compositing " + list[i]);
	run("Merge Channels...", "c2=Wall_Thresholded.png c6=Defocus_Thresholded.png c4=Grayscale.png create");
		//save overlaid images
		savename = output + File.separator + "Defocus_Wall_Composite_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

	//Create Pore + Wall Composite Image
	print("Opening grayscale scaled image");
	filename = input + File.separator + file;
	open(filename);
	print("GrayScaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	rename("Grayscale.png");
	run("8-bit");
	print("Opening Pore_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Pore_Thresholded_" + tempname;
	open(filename);
	rename("Pore_Thresholded.png");
	print("Opening Wall_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Wall_Thresholded_" + tempname;
	open(filename);
	rename("Wall_Thresholded.png");
	print("Compositing " + list[i]);
	run("Merge Channels...", "c1=Pore_Thresholded.png c2=Wall_Thresholded.png c4=Grayscale.png create");
		//save overlaid images
		savename = output + File.separator + "Pore_Wall_Composite_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

	//Create Membrane + Wall Composite Image
	print("Opening grayscale scaled image");
	filename = input + File.separator + file;
	open(filename);
	print("GrayScaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	rename("Grayscale.png");
	run("8-bit");
	print("Opening Pore_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Membrane_Thresholded_" + tempname;
	open(filename);
	rename("Pore_Thresholded.png");
	print("Opening Wall_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Wall_Thresholded_" + tempname;
	open(filename);
	rename("Wall_Thresholded.png");
	print("Compositing " + list[i]);
	run("Merge Channels...", "c2=Wall_Thresholded.png c3=Membrane_Thresholded.png c4=Grayscale.png create");
		//save overlaid images
		savename = output + File.separator + "Membrane_Wall_Composite_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);


	//count Pores by Pore
	print("Opening Pore_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Pore_Thresholded_" + tempname;
	open(filename);
	rename("Pore_Thresholded.png");
	run("Invert");
	
	//Pore analyze particles and save CSV
		print("Analyzing Particles in " + list[i]);
		run("Set Measurements...", "area centroid center perimeter bounding fit shape feret's median area_fraction redirect=None decimal=3");
		run("Analyze Particles...", "size="+stringSize + " circularity="+stringCircularity +" show=Masks display summarize");
		selectWindow("Results"); //Pore Equivalent Diameter Calculation
				p=0; //resets for loop for each table
				for (p=0; (p)<nResults; p++){
				a = getResult("Area",p);
				b = getResult("Perim.",p);
				PoreEquivalentDiameter = 2*pow((a/PI),0.5); //models all the area as a circular pore
				HydraulicDiameter = 4*a/b;
				HydraulicRadius = a/b;
				setResult("Pore_Equivalent_Diameter_[nm]", p,  PoreEquivalentDiameter);
     			setResult("Hydraulic_Diameter_[#]", p,  HydraulicDiameter);
     			setResult("Hydraulic_Radius_[#]", p,  HydraulicRadius);
				}

			updateResults();
			savename = output + File.separator + "Pore_Counts_" + list[i] + ".csv";
			saveAs("Results", savename);
			run("Summarize");
			MeanPoreEquivalentDiameter = getResult("Pore_Equivalent_Diameter_[nm]",p);
			MeanHydraulicDiameter = getResult("Hydraulic_Diameter_[#]",p);
			MeanHydraulicRadius = getResult("Hydraulic_Radius_[#]",p);
			selectWindow("Summary");
			Table.set("Pore_Equivalent_Diameter_[nm]", 0,  MeanPoreEquivalentDiameter); //writes to first line on table
			Table.set("Hydraulic_Diameter_[#]", 0,  MeanHydraulicDiameter); //writes to first line on table
			Table.set("Hydraulic_Radius_[#]", 0,  MeanHydraulicRadius); //writes to first line on table
			Table.update;
		run("Clear Results"); //empty results for next run
		//save counted images
		savename = output + File.separator + "Pore_Counted_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
		//Prepare for composite
		run("Grays");
		rename("Pores_Counted.png");
		
	
	//Create Pores_Counted Composite Image
	print("Opening grayscale scaled image");
	filename = input + File.separator + file;
	open(filename);
	print("GrayScaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	rename("Grayscale.png");
	run("8-bit");
	print("Compositing " + list[i]);
	run("Merge Channels...", "c1=Pores_Counted.png c4=Grayscale.png create");
		//save overlaid images
		savename = output + File.separator + "Pore_Counted_Composite_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

	//count Pores by Defocus
	print("Opening Defocus_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Defocus_Thresholded_" + tempname;
	open(filename);
	rename("Defocus_Thresholded.png");
	run("Invert");
		//analyze particles
		//Pore analyze particles and save CSV
		print("Analyzing Particles in " + list[i]);
		run("Set Measurements...", "area centroid center perimeter bounding fit shape feret's median area_fraction redirect=None decimal=3");
		run("Analyze Particles...", "size="+stringSize + " circularity="+stringCircularity +" show=Masks display summarize");
			selectWindow("Results"); //Pore Equivalent Diameter Calculation
			p=0; //resets for loop for each table
				for (p=0; (p)<nResults; p++){
				a = getResult("Area",p);
				b = getResult("Perim.",p);
				PoreEquivalentDiameter = 2*pow((a/PI),0.5); //models all the area as a circular pore
				HydraulicDiameter = 4*a/b;
				HydraulicRadius = a/b;
				setResult("Pore_Equivalent_Diameter_[nm]", p,  PoreEquivalentDiameter);
     			setResult("Hydraulic_Diameter_[#]", p,  HydraulicDiameter);
     			setResult("Hydraulic_Radius_[#]", p,  HydraulicRadius);
				}
			updateResults();
				savename = output + File.separator + "Defocus_Counts_" + list[i] + ".csv";
				saveAs("Results", savename);
			run("Summarize");
			MeanPoreEquivalentDiameter = getResult("Pore_Equivalent_Diameter_[nm]",p);
			MeanHydraulicDiameter = getResult("Hydraulic_Diameter_[#]",p);
			MeanHydraulicRadius = getResult("Hydraulic_Radius_[#]",p);
			selectWindow("Summary");
			Table.set("Pore_Equivalent_Diameter_[nm]", 1,  MeanPoreEquivalentDiameter); //writes to second line on table
			Table.set("Hydraulic_Diameter_[#]", 1,  MeanHydraulicDiameter); //writes to second line on table
			Table.set("Hydraulic_Radius_[#]", 1,  MeanHydraulicRadius); //writes to second line on table
			Table.update;
		run("Clear Results"); //empty results for next run

		//save counted images
		savename = output + File.separator + "Defocus_Counted_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
		//Prepare for composite
		run("Grays");
		rename("Defocus_Counted.png");

	//Create Defocus_Counted Composite Image
	print("Opening grayscale scaled image");
	filename = input + File.separator + file;
	open(filename);
	print("GrayScaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	rename("Grayscale.png");
	run("8-bit");
	print("Compositing " + list[i]);
	run("Merge Channels...", "c6=Defocus_Counted.png c4=Grayscale.png create");
		//save overlaid images
		savename = output + File.separator + "Defocus_Counted_Composite_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

		

	//count Pores by Membrane
	print("Opening Membrane_Thresholded scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Membrane_Thresholded_" + tempname;
	open(filename);
	rename("Membrane_Thresholded.png");
	//run("Invert"); no need for invert because NOTmembrane = pore
		//analyze particles
		//Pore analyze particles and save CSV
		print("Analyzing Particles in " + list[i]);
		run("Set Measurements...", "area centroid center perimeter bounding fit shape feret's median area_fraction redirect=None decimal=3");
		run("Analyze Particles...", "size=0-Infinity circularity=0.0-1.0 show=Masks display summarize"); //does not count by user defined rules, shows maximum void space
			selectWindow("Results"); //Pore Equivalent Diameter Calculation
			p=0; //resets for loop for each table
				for (p=0; (p)<nResults; p++){
				a = getResult("Area",p);
				b = getResult("Perim.",p);
				PoreEquivalentDiameter = 2*pow((a/PI),0.5); //models all the area as a circular pore
				HydraulicDiameter = 4*a/b;
				HydraulicRadius = a/b;
				setResult("Pore_Equivalent_Diameter_[nm]", p,  PoreEquivalentDiameter);
     			setResult("Hydraulic_Diameter_[#]", p,  HydraulicDiameter);
     			setResult("Hydraulic_Radius_[#]", p,  HydraulicRadius);
				}
			updateResults();
				savename = output + File.separator + "Membrane_Counts_" + list[i] + ".csv";
				saveAs("Results", savename);
			run("Summarize");
			MeanPoreEquivalentDiameter = getResult("Pore_Equivalent_Diameter_[nm]",p);
			MeanHydraulicDiameter = getResult("Hydraulic_Diameter_[#]",p);
			MeanHydraulicRadius = getResult("Hydraulic_Radius_[#]",p);
			selectWindow("Summary");
			Table.set("Pore_Equivalent_Diameter_[nm]", 2,  MeanPoreEquivalentDiameter); //writes to third line on table
			Table.set("Hydraulic_Diameter_[#]", 2,  MeanHydraulicDiameter); //writes to third line on table
			Table.set("Hydraulic_Radius_[#]", 2,  MeanHydraulicRadius); //writes to third line on table
			Table.update;
		run("Clear Results"); //empty results for next run
		//save counted images
		savename = output + File.separator + "Membrane_Counted_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
		//Prepare for composite
		run("Grays");
		rename("Membrane_Counted.png");
		

	//Create Membrane_Counted Composite Image
	print("Opening grayscale scaled image");
	filename = input + File.separator + file;
	open(filename);
	print("GrayScaling " + list[i]);
	run("Size...", "width=1024 height=1024 depth=1 constrain average interpolation=Bilinear");
	rename("Grayscale.png");
	run("8-bit");
	print("Compositing " + list[i]);
	run("Merge Channels...", "c3=Membrane_Counted.png c4=Grayscale.png create");
		//save overlaid images
		savename = output + File.separator + "Membrane_Counted_Composite_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

	//Close All Windows
      while (nImages>0) { 
         selectImage(nImages); 
         close(); 
 	    } 	

	//creating Defocus Analysis Plots
	print("Opening Defocus_Counts Table");
	tempname = list[i] + ".csv";
	filename = output + File.separator + "Defocus_Counts_" + tempname;
	open(filename);
	tempname = "Defocus_Counts_" + tempname;
	Table.rename(tempname, "Results");
	//Number of results in "Area" Column
		N = nResults;
		total_area = 0;
		//Mean "Area"column
		for (a=0; a<nResults(); a++) {
	    total_area=total_area+getResult("Area",a);
    	mean_area=total_area/nResults;
			}
		beta = total_area;
	
	run("Distribution...", "parameter=Minor or=30 and=0-100");
	Plot.getValues(bins, counts);
	Plot.create("Pore Characteristic Plot", "Length [nm]", "Count");
	Plot.add("bar",bins,counts);
	Plot.setStyle(0, "red,red,3.0,Line");

	run("Distribution...", "parameter=Major or=30 and=0-100");
	Plot.getValues(bins, counts);
	Plot.add("bar",bins,counts);
	Plot.setStyle(1, "green,green,3.0,Line");

	run("Distribution...", "parameter=Pore_Equivalent_Diameter_[nm] or=30 and=0-100");
	Plot.getValues(bins, counts);
	Plot.add("bar",bins,counts);
	Plot.setStyle(2, "blue,blue,3.0,Line");
	
	Plot.setLegend("Minor Axis\tMajor Axis\tEquivalent Diameter", "top-right")
	run("Plots...", "width=750 height=500 font=30 draw draw_ticks minimum=0 maximum=0 interpolate");
	Plot.setFontSize(20.0);
	Plot.setAxisLabelSize(25.0, "plain");
	Plot.setXYLabels("Length [nm]", "Count");
	Plot.setFormatFlags("11001100111111");	
	Plot.show();
	run("Duplicate...", "Pore Distributions");
		//save overlaid images
		savename = output + File.separator + "Analysis_Defocus_Montage_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
	run("Clear Results"); //empty results for next run
	close();

	//Close All Windows
      while (nImages>0) { 
         selectImage(nImages); 
         close(); 
 	    } 

 	 //creating Pore Analysis Plots
	print("Opening Pore_Counts Table");
	tempname = list[i] + ".csv";
	filename = output + File.separator + "Pore_Counts_" + tempname;
	open(filename);
	tempname = "Pore_Counts_" + tempname;
	Table.rename(tempname, "Results");
	//Number of results in "Area" Column
		N = nResults;
		total_area = 0;
		//Mean "Area"column
		for (a=0; a<nResults(); a++) {
	    total_area=total_area+getResult("Area",a);
    	mean_area=total_area/nResults;
			}
		alpha = total_area;	

	run("Distribution...", "parameter=Minor or=30 and=0-100");
	Plot.getValues(bins, counts);
	Plot.create("Pore Characteristic Plot", "Length [nm]", "Count");
	Plot.add("bar",bins,counts);
	Plot.setStyle(0, "red,red,3.0,Line");

	run("Distribution...", "parameter=Major or=30 and=0-100");
	Plot.getValues(bins, counts);
	Plot.add("bar",bins,counts);
	Plot.setStyle(1, "green,green,3.0,Line");

	run("Distribution...", "parameter=Pore_Equivalent_Diameter_[nm] or=30 and=0-100");
	Plot.getValues(bins, counts);
	Plot.add("bar",bins,counts);
	Plot.setStyle(2, "blue,blue,3.0,Line");
	
	Plot.setLegend("Minor Axis\tMajor Axis\tEquivalent Diameter", "top-right")
	run("Plots...", "width=750 height=500 font=30 draw draw_ticks minimum=0 maximum=0 interpolate");
	Plot.setFontSize(20.0);
	Plot.setAxisLabelSize(25.0, "plain");
	Plot.setXYLabels("Length [nm]", "Count");
	Plot.setFormatFlags("11001100111111");	
	Plot.show();
	run("Duplicate...", "Pore Distributions");
		//save overlaid images
		savename = output + File.separator + "Analysis_Pore_Montage_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
	run("Clear Results"); //empty results for next run
	close();

	//Close All Windows
      while (nImages>0) { 
         selectImage(nImages); 
         close(); 
 	    }

 	 //Probability Heat Map Plot Montage
	  print("Opening Probability Maps");
		tempname = list[i];
		filename = output + File.separator + "Probability_Maps_" + tempname;
	  open(filename);
	  run("8-bit");
	  run("Fire");
	  setForegroundColor(0, 255, 121);
 	  run("RGB Color");
	  run("Make Montage...", "columns=2 rows=2 scale=0.5 font=25 label use");
	  	//save overlaid images
		savename = output + File.separator + "Montage_Probability_Maps_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);

	//Close All Windows
      while (nImages>0) { 
         selectImage(nImages); 
         close(); 
 	    }

 	//Summary Window 
	
 	
	print("Opening Pore_Counted_Composite scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Pore_Counted_Composite_" + tempname;
	open(filename);
	rename("A.png");
	//setFont("SansSerif", 72, " antialiased");
	//drawString("Pore Class", 0, 72, "white");
	//run("Flatten");
	//Overlay.clear;
	
	print("Opening Analysis_Pore_Montage scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Analysis_Pore_Montage_" + tempname;
	open(filename);
	rename("B.png");
	
	print("Opening Defocus_Counted_Composite scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Defocus_Counted_Composite_" + tempname;
	open(filename);
	rename("C.png");
	//setFont("SansSerif", 72, " antialiased");
	//drawString("Defocus Class", 0, 72, "white");
	//run("Flatten");
	//Overlay.clear;
	
	print("Opening Analysis_Defocus_Montage scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Analysis_Defocus_Montage_" + tempname;
	open(filename); 
	rename("D.png");
	run("Images to Stack", "method=[Copy (center)] name=Stack title=[] use");
	run("Make Montage...", "columns=2 rows=2 scale=0.5");
	rename("2-Analysis");

	print("Opening scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Scaled_" + tempname;
	open(filename);
	rename("1-Grayscaled");

	print("Opening scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Membrane_Counted_Composite_" + tempname;
	open(filename);
	rename("4-DivotFraction");

	

	//get stats
	selectWindow("Summary");
	poreporosity = getResult("%Area",0); //pores porosity
	poremeanmajor = getResult("Major",0);
	poremeanminor = getResult("Minor",0);
	porecount = getResult("Count",0);
	poreeqd = getResult("Pore_Equivalent_Diameter_[nm]",0);
	porehd = getResult("Hydraulic_Diameter_[#]",0);
	porehr = getResult("Hydraulic_Radius_[#]",0);
	defocusporosity = getResult("%Area",1); //defocus porosity
	defocusmeanmajor = getResult("Major",1);
	defocusmeanminor = getResult("Minor",1);
	defocuscount = getResult("Count",1);
	defocuseqd = getResult("Pore_Equivalent_Diameter_[nm]",1);
	defocushd = getResult("Hydraulic_Diameter_[#]",1);
	defocushr = getResult("Hydraulic_Radius_[#]",1);
	divotfraction = getResult("%Area",2);
	Table.deleteRows(0, 2, "Summary");
	

	//stamp stats on analysis image
	selectWindow("2-Analysis");
	setForegroundColor(0, 0, 0); //set black as text color
	setFont("SansSerif", 20, " antialiased");
	//drawString(list[i], 0, 40, "white");
	XXX = "Defocus Porosity = " + toString(defocusporosity,1) + "%";
	drawString(XXX, 512, 542, "white");
	XXX = "Defocus Mean Max/Min Diameter = " + toString(defocusmeanmajor,1)+"/"+toString(defocusmeanminor,1) + " nm";
	drawString(XXX, 512, 572, "white");
	XXX = "Defocus Mean Equivalent Diameter = " + toString(defocuseqd,1) + " nm";
	drawString(XXX, 512, 602, "white");
	XXX = "Defocus Count = " + toString(defocuscount);
	drawString(XXX, 512, 632, "white");
	XXX = "Pore Porosity = " + toString(poreporosity,1) + "%";
	drawString(XXX, 512, 30, "white");
	XXX = "Pore Mean Max/Min Diameter = " + toString(poremeanmajor,1)+"/"+toString(poremeanminor,1) + " nm";
	drawString(XXX, 512, 60, "white");
	XXX = "Pore Mean Equivalent Diameter = " + toString(poreeqd,1) + " nm";
	drawString(XXX, 512, 90, "white");
	XXX = "Pore Count = " + toString(porecount);
	drawString(XXX, 512, 120, "white");
	
	run("Flatten");
	Overlay.clear;
	run("Clear Results");
	close();

	//stamp title on grayscaled image
	selectWindow("1-Grayscaled");
	setForegroundColor(0, 0, 0); //set black as text color
	setFont("SansSerif", 30, " antialiased");
	drawString(list[i], 0, 80, "white");
	XXX = inputFolderName;
	drawString(XXX, 0, 40, "white");
	XXX = "Circularity Selected Range = " + stringCircularity; //stamp on classifier
	drawString(XXX, 490, 1024, "white");
	XXX = "Size Selected Range = " + stringSize; //stamp on classifier
	drawString(XXX, 512, 984, "white");

	//stamp title on divot image
	selectWindow("4-DivotFraction");
	setForegroundColor(0, 0, 0); //set black as text color
	setFont("SansSerif", 30, " antialiased");
	XXX = "Divot Fraction = " + toString(divotfraction) +"%";
	drawString(XXX, 0, 40, "white");

	//addprobability montage to summary figure
	print("Opening Montage_Probability_Maps scaled image");
	tempname = replace(list[i], ".tif",".png");
	filename = output + File.separator + "Montage_Probability_Maps_" + tempname;
	open(filename);
	setForegroundColor(0, 0, 0); //set black as text color
	setFont("SansSerif", 30, " antialiased");
	wekaName = File.getName(wekaModel); 
	wekaName = substring(wekaName, 0, lastIndexOf(wekaName, "."));
	XXX = "Classifier Model = " + wekaName; //stamp on classifier
	drawString(XXX, 0, 30, "white");
	run("Flatten");
	rename("3-Probability"); 
	
	//run("Images to Stack", "method=[Copy (center)] name=Stack title=[] use");
	selectWindow("1-Grayscaled");
	run("RGB Color");
	rename("Summary Montage");
	selectWindow("2-Analysis");
	run("Select All");
	run("Copy");
	selectWindow("Summary Montage");
	run("Add Slice");
	run("Select All");
	run("Paste");
	selectWindow("4-DivotFraction");
	run("Select All");
	run("Copy");
	selectWindow("Summary Montage");
	run("Add Slice");
	run("Select All");
	run("Paste");
	selectWindow("3-Probability");
	run("Select All");
	run("Copy");
	selectWindow("Summary Montage");
	run("Add Slice");
	run("Select All");
	run("Paste");

	//make montage
	run("Make Montage...", "columns=2 rows=2 scale=1 border=2");
	//save  images
		//savename = output + File.separator + "Summary_" + list[i];
		//print("Saving to: " + savename);
		//saveAs("png",savename);
		savename = outputSummaries + File.separator + "Summary_" + list[i];
		print("Saving to: " + savename);
		saveAs("png",savename);
	
	//Close All Windows
      while (nImages>0) { 
         selectImage(nImages); 
         close(); 
 	    }

 	 //close Summary window
 	 close("Summary");   
 	    
	//garbage collection
	wait(1000);
	call("java.lang.System.gc");

	output = outputRaw; //change output back to highest level folder
	fileTimeEnd = getTime();
	fileProcessTime = (fileTimeEnd - fileTimeStart)/60000; //time to process in minutes
	folderTimeElapsed = (fileTimeEnd - startTime)/60000;
	
	print("*** Done Processing " + file + " in " + fileProcessTime + " minutes ***");
	print("*** Folder Time Elapsed : " + folderTimeElapsed + " minutes ***");
 	    
}




//finishtime
finishTime = (getTime() - startTime)/60000;

print("*** Done Processing Folder in " + finishTime + " minutes ***");


